import Vue from 'vue';
import DatePicker from "v-calendar/lib/components/date-picker.umd";

const  CandidateCareerPage = () => import(/* webpackChunkName: "client-components" */ './Components/Views/CareerPage/CandidateCareerPage.vue');
const  CandidateApplicationForm = () => import(/* webpackChunkName: "client-components" */ './Components/Views/Candidates/CandidateApplicationForm');
const  CandidateApplicationFormCus = () => import(/* webpackChunkName: "client-components" */ './Components/Views/Candidates/FormApplication/CandidateApplicationForm');
const  CandidateJobPost = () => import(/* webpackChunkName: "client-components" */ './Components/Views/Dashboard/CandidateJobPost');
const  CandidateEmailVerificationModal = () => import(/* webpackChunkName: "client-components" */ './Components/Views/Candidates/Helpers/CandidateEmailVerificationModal');
const  AppModal = () => import(/* webpackChunkName: "client-components" */ '../core/components/modal/Modal');
const  AppInput = () => import(/* webpackChunkName: "client-components" */ '../core/components/input/Index');
const  AppIcon = () => import(/* webpackChunkName: "client-components" */ '../core/components/icon/Icon');
const  AppPreLoader = () => import(/* webpackChunkName: "client-components" */ '../core/components/preloders/Preloader');
const  AppOverlayLoader = () => import(/* webpackChunkName: "client-components" */ '../core/components/preloders/OverlayLoader');
const  AppConfirmationModal = () => import(/* webpackChunkName: "client-components" */ '../core/components/confirmation-modal/Index');


// Candidate Public Module
Vue.component('candidate-career-page', CandidateCareerPage);
Vue.component('candidate-application-form',CandidateApplicationForm);
Vue.component('candidate-application-form-cus', CandidateApplicationFormCus);
Vue.component('candidate-job-post', CandidateJobPost);
Vue.component('candidate-email-verification-modal',CandidateEmailVerificationModal);

Vue.component('app-modal', AppModal);
Vue.component('app-input', AppInput);
Vue.component('app-icon', AppIcon);
Vue.component('app-pre-loader', AppPreLoader);
Vue.component('app-overlay-loader', AppOverlayLoader);
Vue.component("app-confirmation-modal", AppConfirmationModal);
Vue.component("modal", require('../app/Components/Helpers/Modal/Modal.vue').default);

Vue.component('v-date-picker', DatePicker);