<?php

return array_merge([
    // Responses
    'created_response' => ':name has been created successfully',
    'updated_response' => ':name has been updated successfully',
    'deleted_response' => ':name has been deleted successfully',
    'failed_response' => 'Something went wrong',
    'notified' => ':name has been notified successfully',
    'duplicated_response' => ':name has been duplicated successfully',
    'status_updated_response' => ':name status has been changed to :status',
    'action_not_allowed' => 'You are not allowed for this action',
    'cant_delete_own_account' => 'You can\'t delete your own account',
    'attached_response' => ':name has been attached successfully',
    'detached_response' => ':name has been detached successfully',
    'default_delete' => 'You can not delete the default :name .',
    'default_update' => 'You can not update the default :name',
    'old_password_is_in_correct' => 'Old password is incorrect',
    'attach_log' => 'New :pivot attached to :model',
    'detach_log' => ':pivot detached from :model',
    'status_log' => ':model has been :status',
    'incorrect_user_password' => 'Incorrect user or password',
    'invite_user_response' => 'User has been invited successfully',
    'invalid_token' => 'The token is Invalid',
    'user_account_confirmed' => 'Your account has been confirmed successfully',
    'user_invited_to_join' => 'An user has been invited to join',
    'user_confirm_joining' => 'User confirmed his joining',
    'log_description_message' => ':model has been :event',
    'password_reset_mail_has_been_sent_successfully' => 'We sent an email containing password reset link to your email address. Please check it',
    'no_user_found_on_that_email' => 'No user found of that email address.',
    'password_has_been_reset_successfully' => 'Your password has been reset successfully',
    'resource_not_found' => 'The :resource you are looking for is not found.',
    'created' => 'Created',
    'deleted' => 'Deleted',
    'updated' => 'updated',
    'resource' => 'resource',
    'csrf_token_mismatch_message' => 'Maybe you are in a frame. Please remove the frame and try again',

    // Number of Decimal
    '0' => 'ZERO (0)',

    //HTTP Responses
    '200' => 'Success',

    //Number of Decimal
    '2' => 'TWO (2)',

    // HTTP Responses
    '400' => 'Bad Request',
    '401' => 'Unauthorized',
    '403' => 'Forbidden',
    '404' => 'Not Found',
    '413' => 'Payload too large',
    '414' => 'URI Too long',
    '415' => 'Unsupported Media Type',
    '426' => 'Upgrade Required',
    '429' => 'Too Many Requests',

    // Features

    // Custom Field Builder
    'custom_field' => 'Custom field',
    'custom_field_type' => 'Custom field Type',

    // Fields
    'text' => 'Text',
    'textarea' => 'Textarea',
    'checkbox' => 'Checkbox',
    'radio_button' => 'Radio Button',
    'select' => 'Select',
    'number' => 'Number',
    'multi_select' => 'Multi Select',
    'tel_input' => 'Telephone',
    'did_not_match_anything' => "Didn't match anything",
    'enter_to_add_new' => 'Enter to add new',
    'no_options_found' => 'No options found',
    'pick_a_color' => 'Pick a color',

    // Notification event
    'notification_event_name' => ':name :action',
    'notification_created' => 'created',
    'notification_updated' => 'updated',
    'notification_deleted' => 'deleted',
    'notification_user' => 'user',
    'notification_reset' => 'reset',
    'notification_invited' => 'invited',

    // Notifications
    'notification' => 'Notification',
    'notify_by_email' => 'Notify by Email',
    'notify_by_sms' => 'Notify by SMS',
    'notification_settings' => 'Notification settings',
    'notification_template' => 'Notification template',

    // Labels
    'user' => 'User',
    'brand' => 'Brand',
    'status' => 'Status',
    'name' => 'Name',
    'mail' => 'Mail',
    'value' => 'Value',
    'type' => 'Type',
    'database' => 'System',
    'sms' => 'SMS',
    'users' => 'Users',
    'roles' => 'Roles',
    'role' => 'Role',
    'permissions' => 'Permissions',
    'permission' => 'Permission',
    'settings' => 'Settings',
    'password' => 'Password',
    'show_password' => 'Show password',
    'hide_password' => 'Hide password',
    'allowed' => 'allowed',
    'profile_picture' => 'Profile picture',
    'delivery_settings' => 'Email settings',
    'brand_settings' => 'Brand settings',
    'privacy_settings' => 'Privacy settings',
    'corn_job' => 'Corn job',
    'brand_group' => 'Brand group',
    'template' => 'Template',
    'profile' => 'Profile',
    'log' => 'Log',
    'invite' => 'Invite',

    // Add and all labels
    'field_label' => '{subject} {key}',
    'all_feature_name' => 'All {name}',
    'add_feature_name' => 'Add {name}',
    'create_feature_name' => 'Create {name}',
    'edit_feature_name' => 'Edit {name}',
    'copy_feature_name' => 'Copy {name}',
    'choose_feature_name' => 'Choose {name}',
    'field_title' => '{subject} {infix} {title}',
    'place_holder' => 'Enter {subject} {type}',

    //Settings
    'app_name' => 'App Name',
    'brand_name' => 'Brand Name',

    // Status
    'status_active' => 'Active',
    'status_pending' => 'Pending',
    'status_done' => 'Done',
    'status_deleted' => 'Deleted',
    'status_processing' => 'Processing',
    'status_sent' => 'Sent',
    'status_draft' => 'Draft in es',
    'status_regular' => 'Regular',
    'status_auto' => 'Auto',
    'status_dynamic' => 'Dynamic',
    'status_imported' => 'Imported',
    'status_black-listed' => 'Black listed',
    'status_inactive' => 'Inactive',
    'status_hired' => 'Hired',
    'status_disqualified' => 'Disqualified',
    'status_in_progress' => 'In progress',
    'status_open' => 'Active',
    'status_closed' => 'Inactive',
    'status_new' => 'New',

    // Permissions
    'manage_dashboard' => 'Can manage app dashboard',
    'view_users' => 'Can view list of user',
    'create_users' => 'Can create an user',
    'update_users' => 'Can update an user',
    'delete_users' => 'Can delete an user',
    'cancel_user_invitation' => 'Can cancel user invitation',
    'view_brands' => 'Can view list of brand',
    'create_brands' => 'Can create brand',
    'update_brands' => 'Can update brand',
    'delete_brands' => 'Can delete brand',
    'user_list_brands' => 'Can view users of a brand',
    'attach_users_brands' => 'Can attach user to brand',
    'detach_users_brands' => 'Can detach user from a brand',
    'brand_list_users' => 'Can view brands of a user',
    'manage_brand_dashboard' => 'Can view brand dashboard',
    'update_brand_privacy_settings' => 'Can update brand privacy from app',
    'view_brand_privacy_settings' => 'Can view brand privacy from app',
    'view_roles' => 'Can view list of role',
    'create_roles' => 'Can create role',
    'update_roles' => 'Can update role',
    'delete_roles' => 'Can delete role',
    'view_settings' => 'Can view list of setting',
    'update_settings' => 'Can update setting',
    'view_permission' => 'Can view list of permission',
    'view_custom_fields' => 'Can view list of custom field',
    'create_custom_fields' => 'Can create custom field',
    'update_custom_fields' => 'Can update custom field',
    'delete_custom_fields' => 'Can delete custom field',
    'attach_roles_users' => 'Can attach roles to users',
    'detach_roles_users' => 'Can detach roles from users',
    'attach_permissions_roles' => 'Can attach permissions to role',
    'detach_permissions_roles' => 'Can detach permissions from role',
    'change_settings_users' => 'Can change own settings',
    'settings_list_users' => 'Can view settings list',
    'change_password_users' => 'Can change user password',
    'change_profile_picture_users' => 'Can change profile picture',
    'update_delivery_settings' => 'Can update email settings',
    'update_corn_job_settings' => 'Can update corn job settings',
    'view_corn_job_settings' => 'Can view corn job settings',
    'view_delivery_settings' => 'Can view email settings',
    'view_brand_delivery_settings' => 'Can view brand delivery settings',
    'view_notification_settings' => 'Can view notification settings',
    'update_notification_settings' => 'Can update notification settings',
    'create_brand_groups' => 'Can create brand group',
    'view_brand_groups' => 'Can view brand group',
    'update_brand_groups' => 'Can update brand group',
    'delete_brand_groups' => 'Can delete brand group',
    'attach_brand_brand_groups' => 'Can attach brand to brand group',
    'detach_brand_brand_groups' => 'Can detach brand from brand group',
    'view_brands_brand_groups' => 'Can view brands of a brand group',
    'view_notification_templates' => 'Can view notification templates',
    'create_notification_templates' => 'Can create notification templates',
    'update_notification_templates' => 'Can update notification templates',
    'delete_notification_templates' => 'Can delete notification templates',
    'attach_templates_notification_events' => 'Can attach templates to notification event',
    'detach_templates_notification_events' => 'Can detach templates to notification event',
    'view_activity_logs' => 'Can view activity log',
    'view_templates' => 'Can view templates',
    'create_templates' => 'Can create templates',
    'update_templates' => 'Can update templates',
    'delete_templates' => 'Can delete templates',
    'invite_user' => 'Can invite user',
    'manage_job_posts' => 'Can manage job posts',
    'already_applied_with_this_email' => 'Sorry, Candidate already applied/assigned for this job.',
    'candidate_already_exist' => 'Sorry, candidate already exists in our system.',
    'failed_to_store_attendees' => 'Sorry, Attendee/s failed to store in system.',
    'failed_to_store_job_applicant' => 'Sorry, job applicant data are Job_post_not_found failed to store in system.',
    'job_post_not_found' => 'Job post not found.',
    'apply_form_settings' => 'Apply form settings.',
    'candidate_applied_successfully' => 'Thank you, your application has been submitted successfully.',

    'date_format' => 'Date format',
    'time_format' => 'Time format',
    'decimal_separator' => 'Decimal separator',
    'thousand_separator' => 'Thousand separator',
    'number_of_decimal' => 'Number of decimal',
    'currency_position' => 'Currency position',

    // Language
    'en' => 'English',

    // Date Format
    'dd-mm-yyyy' => 'DD-MM-YYYY',
    'd-m-Y' => 'DD-MM-YYYY',
    'm-d-Y' => 'MM-DD-YYYY',
    'Y-m-d' => 'YYYY-MM-DD',
    'm/d/Y' => 'MM/DD/YYYY',
    'd/m/Y' => 'DD/MM/YYYY',
    'Y/m/d' => 'YYYY/MM/DD',
    'm.d.Y' => 'MM.DD.YYYY',
    'd.m.Y' => 'DD.MM.YYYY',
    'Y.m.d' => 'YYYY.MM.DD',

    // Time Format
    'h' => '12 HOURS',
    'H' => '24 HOURS',

    // Decimal and Thousand Separator
    '.' => 'DOT(.)',
    ',' => 'COMMA(,)',
    ' ' => 'Space',

    // Currency Positions
    'prefix_only' => '$1,100.00',
    'prefix_with_space' => '$ 1,100.00',
    'suffix_only' => '1,100.00$',
    'suffix_with_space' => '1,100.00 $',

    // Validation
    'is_required' => 'is required',
    'and' => 'and',
    'this_field_is_required' => 'This field is required',
    'this_field_is_invalid' => 'This field is invalid',
    'this_field_is_not_alphanumeric' => 'This field is not alphanumeric',
    'passwords_are_not_matched' => 'Passwords are not matched',
    'please_enter_a_strong_password' => 'Please enter a strong password.',
    'are_not_match' => 'are not match',
    'can_not_before' => 'can not before',
    'is_invalid' => 'is invalid',
    'minimum_length_is' => 'Minimum length is',
    'maximum_length_is' => 'Maximum length is',
    'maximum_number_is' => 'Maximum number is',
    'minimum_number_is' => 'Minimum number is',
    'is_not_alphanumeric' => 'is not alphanumeric',
    'not_found' => 'Not found',

    // Btn
    'load_more' => 'Load more',
    'apply' => 'Apply',
    'clear' => 'Clear',
    'close' => 'Close',
    'yes' => 'Yes',
    'no' => 'No',
    'more' => 'more',
    'actions' => 'Actions',

    // Multi select component
    'add' => 'add',

    // Datatable
    'items_showing_per_page' => 'Items showing per page',
    'items_selected' => 'items selected',
    'select_all' => 'Select all',
    'clear_selection' => 'Clear selection',
    'showing' => 'Showing',
    'to' => 'to',
    'items' => 'items',
    'of' => 'of',

    // Filters
    'filters' => 'Filters',
    'minimum_rate' => 'Minimum rate',
    'maximum_rate' => 'Maximum rate',
    'want_to_manage_datatable' => 'Want to manage datatable?',
    'please_drag_and_drop_your_column_to_reorder_your_table_and_enable_see_option_as_you_want' => 'Please drag and drop your column to reorder your table and enable see option as you want.',
    'manage_columns' => 'Manage Columns',
    'search' => 'Buscar',
    'today' => 'Today',
    'date' => 'Date',
    'select_an_option' => 'Select an option',
    'clear_all_filters' => 'Clear all filters',

    // Modal
    'are_you_sure' => 'Are you sure?',
    'this_content_will_be_deleted_permanently' => 'This content will be deleted permanently.',

    // Empty data
    'nothing_to_show_here' => 'Nothing to show here',
    'thank_you' => 'Thank you',
    'go_back_to_your_page' => 'Go back to your page',
    'something_went_wrong' => 'Something went wrong!',
    'empty_data_block_dummy_message' => 'Please add a new entity or manage the data table to see the content here',

    // File upload
    'change_image' => 'Change Image',
    'choose_file' => 'Choose File',
    'drag_and_drop' => 'Drag & Drop',
    'or' => 'or',
    'browse' => 'Browse',

    // No notification
    'no_notification_one' => "It's very much boring to do as usual stuff, let's have a party with some beer!",
    'no_notification_two' => 'Are you hungry there? Please have good food and get back to work.',
    'no_notification_three' => 'Rock & role time! Turn on your music and have some fun with your team.',
    'all_notifications' => 'All Notifications',

    // Tooltip titles
    'collapse_sidebar' => 'Collapse sidebar',
    'floating_sidebar' => 'Floating sidebar',
    'full_sidebar' => 'Full sidebar',
    'light_mood' => 'Light mood',
    'dark_mood' => 'Dark mood',
    'fullscreen' => 'Fullscreen',
    'exit_fullscreen' => 'Exit fullscreen',

    // Tenant Preview Card
    'invited_by' => 'Invited by',
    'short_name' => 'Short name',
    'group' => 'Group',
    'go_to_dashboard' => 'Go To Dashboard',
    'user_invitation_canceled_successfully' => 'User invitation canceled successfully.',

    // Time - picker input
    'am' => 'AM',
    'pm' => 'PM',

    // Job point
    'job' => 'Job',
    'jobs' => 'Jobs',
    'view' => 'View',
    'print' => 'Print',
    'todos' => 'To-dos',
    'mobile' => 'Mobile',
    'change' => 'Change',
    'fields' => 'Fields',
    'reviews' => 'Reviews',
    'options' => 'Options',
    'desktop' => 'Desktop',
    'promote' => 'Promote',
    'preview' => 'Preview',
    'view_job' => 'View job',
    'no_items' => 'No items',
    'overview' => 'Overview',
    'question' => 'Question',
    'location' => 'Location',
    'view_all' => 'View all',
    'job_type' => 'Job type',
    'brief' => 'Brief',
    'type_brief' => 'Type brief',
    'education' => 'Educación',
    'candidate' => 'Candidate',
    'attendees' => 'Attendees',
    'clear_all' => 'Clear all',
    'apply_now' => 'Apply now',
    'questions' => 'Questions',
    'disqualify' => 'Disqualify',
    'all_events' => 'All events',
    'candidates' => 'Candidates',
    'assignment' => 'Asignación',
    'add_option' => 'Add option',
    'apply_form' => 'Apply form',
    'job_stages' => 'Job stages',
    'experience' => 'Experience',
    'add_a_todo' => 'Add a to-do',
    'page_blocks' => 'Page blocks',
    'description' => 'Description',
    'your_events' => 'Your events',
    'your_to_dos' => 'Your to-dos',
    'add_a_stage' => 'Add a stage',
    'answer_type' => 'Answer type',
    'publish_job' => 'Publish job',
    'career_page' => 'Career page',
    'hiring_team' => 'Hiring team',
    'job_openings' => 'Job Openings',
    'save_changes' => 'Save changes',
    'page_styling' => 'Page styling',
    'job_settings' => 'Job settings',
    'compose_mail' => 'Compose mail',
    'applied_date' => 'Applied date',
    'dashboard_title' => 'Panel',
    'resume_upload' => 'Continuar con la carga',
    'toggle_editor' => 'Toggle editor',
    'apply_changes' => 'Apply changes',
    'candidate_already_added' => 'This candidate already added!',
    'toggle_button' => 'Toggle buttons',
    'event_schedule' => 'Event schedule',
    'new_job' => 'New job',
    'current_job' => 'Current job',
    'share_settings' => 'Share settings',
    'hiring_process' => 'Hiring process',
    'job_settings_menu' => 'Job Settings',
    'department' => 'Department',
    'add_more_fields' => 'Add more fields',
    'view_apply_form' => 'View apply form',
    'apply_for_the_post' => 'Apply for the post',
    'stage' => 'Stage',
    'move_to_stage' => 'Move to stage',
    'hiring_stage' => 'Hiring Stage',
    'in' => 'in',
    'already' => 'Already',
    'stage_delete_confirmation' => 'Hold & Think!',
    'move_and_delete' => 'Move & Delete',
    'click_to_choose_stage' => 'Click to choose stage',
    'choose_stage_before_delete' => 'Please choose a stage to move candidate before deleting the stage',
    'contact_details' => 'Detalles de contacto',
    'add_new_question' => 'Add new question',
    'application_form' => 'Application form',
    'global_application_form' => 'Application form',
    'require_an_answer' => 'Require an answer',
    'choose_event_type' => 'Choose event type',
    'choose_an_option' => 'Choose an option',
    'get_sharable_link' => 'Get sharable link',
    'submit_application' => 'Presentar la solicitud',
    'manage_hiring_team' => 'Manage hiring team',
    'confirmation_email' => 'Confirmation email',
    'write_your_question' => 'Write your question',
    'personal_information' => 'Personal information',
    'choose_question_type' => 'Choose question type',
    'hide_from_apply_form' => 'Hide from apply form',
    'write_your_assignment' => 'Write your assignment',
    'no_todos_title' => 'Chill out! You have no pending todos.',
    'no_events_title' => 'You have no pending events!',
    'assignment_input_hint' => 'Applicant can upload one file',
    'please_check_the_information_you_submitted' => 'Please check the information you submitted.',
    'job_stages_setting_subtitle' => 'Edit, add, rearrange or delete the job stages for this job opening.',
    'add_more_section' => 'Add more section',
    'add_new_section' => 'Add new section',
    'enter_section_name' => 'Enter section name',
    'company_location' => 'Company location',
    'basic_information' => 'Información básica',
    'education_experience' => 'Experiencia educacional',
    'visible_in_apply_form' => 'Visible in apply form',
    'section_name_is_required' => 'Section name is required',
    'option_should_not_be_empty' => 'Option should not be empty!',
    'please_fill_all_fields' => 'Please fill all fields',
    'please_fill_the_field' => 'Please fill the field',
    'job_point_description' => 'Company can manage their recruitments process easily',

    'type_option_name' => 'Type option name',
    'add_fields' => 'Add fields',
    'previous' => 'Previous',
    'next' => 'Next',
    'current_stage' => 'Current Stage',
    'applied_job' => 'Applied Job',
    'this_candidate_has_applied' => 'This candidate has applied',
    'applied' => 'Applied',
    'job_application' => 'Job Application',
    'assign_job' => 'Assign Job',
    'single' => 'Single',
    'multi' => 'Multi',
    'last' => 'Last',
    'created_date' => 'Created Date',
    'unassigned_job' => 'Unassigned job',
    'verify_email' => 'Verify Email',
    'delete_candidate_notice' => 'Deletion of candidate may delete all record of applications',
    'job_unassigned_notice' => 'Are you sure to remove job from this candidate',
    'candidate_already_exist_wait_for_assigning_candidate_to_this_job' => 'Candidate already exists!<br/>Please wait for assigning to this job',
    'select_a_job' => 'Select a job',
    'applicant_details' => 'Applicant Details',
    'questions_answers' => 'Questions & Answers',
    'attachments' => 'attachments',
    'you_dont_have_permission_to_view_details' => 'You don\'t have permission to view details!',
    'this_candidate_have_no_attachment' => 'This candidate have no attachment',
    'this_candidate_have_no_event_yet' => 'This candidate have no event yet',
    'no_question_answer_found' => 'Sorry! No question answer found',
    'no_logs_available' => 'No logs available',
    'no_comments_available' => 'No comments available',
    'resume' => 'Resume',

    //User Roles and Permission - Job Point

    // Dashboard Permissions-------------------------------------------------
    'view_dashboard' => 'Can view dashboard',
    'can_view_job_post' => 'Can view job list',
    'can_create_job_post' => 'Can create new job',
    'can_update_job_post' => 'Can edit job',
    'can_delete_job_post' => 'Can delete job',

    'can_view_job_overview' => 'Can view job overview',
    'can_view_applicants_job_overview' => 'Can view candidate list from job overview',

    'can_sharable_link_job_post' => 'Can generate sharable link for job post',
    'can_update_job_post_setting_job_post' => 'Can edit job post setting',
    'can_view_job_post_setting' => 'Can view job post setting',
    'can_manage_job_post_application_form' => 'Can manage job post application form',
    'can_change_job_post_status' => 'Can change job post status (Activate/Deactivate/Publish)',
    'can_view_job_stage' => 'Can view specific job stage',
    'can_create_job_stage' => 'Can create specific job stage',
    'can_update_job_stage' => 'Can update specific job stage',
    'can_delete_job_stage' => 'Can delete specific job stage',
    'can_view_hiring_team' => 'Can view hiring team',
    'can_create_hiring_team' => 'Can assign team member',
    'can_delete_hiring_team' => 'Can delete hiring team',
    'can_manage_sharable_thumbnail' => 'Can manage job post sharable thumbnail',

    // Candidate Permissions -----------------------------------------------
    'can_view_event' => 'Can view event',
    'can_create_event' => 'Can create event',
    'can_update_event' => 'Can update event',
    'can_delete_event' => 'Can delete event',
    'can_create_applicant' => 'Can create candidate',
    'can_update_applicant' => 'Can update candidate',
    'can_view_applicant' => 'Can view candidate',
    'can_delete_applicant' => 'Can delete candidate',
    'can_view_job_applicant_timeline' => 'Can view job candidate timeline',
    'can_view_applicant_details' => 'Can view candidate details',
    'can_send_email_job_applicant' => 'Can send email to candidate',
    'can_change_stage_job_applicant' => 'Can change stage job candidate',
    'can_change_review_job_applicant' => 'Can change review job candidate',
    'can_disqualify_job_applicant' => 'Can disqualify job candidate',
    'can_view_note_by_recruiters' => 'Can view note by recruiters',
    'can_view_job_applicant' => 'Can view details about candidate application of a job',
    'can_create_job_applicant' => 'Can assign candidate to job',
    'can_delete_job_applicant' => 'Can unassigned candidate from job',
    'can_view_events_for_job_applicant' => 'Can view events for job candidate',
    'can_view_note' => 'Can view note',
    'can_create_note' => 'Can create note',
    'can_update_note' => 'Can update note',
    'can_delete_note' => 'Can delete note',

    // Career Page Permissions -----------------------------------------------
    'can_view_career_page' => 'Can view career page',
    'can_update_career_page' => 'Can update career page',

    // Job Settings Permissions ----------------------------------------------
    'can_view_job_setting' => 'Can view job settings',
    'can_manage_global_application_form' => 'Can manage global application form',
    'can_view_event_type' => 'Can view event type',
    'can_create_event_type' => 'Can create event type',
    'can_update_event_type' => 'Can update event type',
    'can_delete_event_type' => 'Can delete event type',
    'can_view_job_type' => 'Can view job type',
    'can_create_job_type' => 'Can create job type',
    'can_update_job_type' => 'Can update job type',
    'can_delete_job_type' => 'Can delete job type',
    'can_view_company_location' => 'Can view company location',
    'can_create_company_location' => 'Can create company location',
    'can_update_company_location' => 'Can update company location',
    'can_delete_company_location' => 'Can delete company location',
    'can_view_department' => 'Can view department',
    'can_create_department' => 'Can create department',
    'can_update_department' => 'Can update department',
    'can_delete_department' => 'Can delete department',
    'can_view_stage' => 'Can view stage',
    'can_create_stage' => 'Can create stage',
    'can_update_stage' => 'Can update stage',
    'can_delete_stage' => 'Can delete stage',
    'can_view_experience_level' => 'Can view experience level',
    'can_create_experience_level' => 'Can create experience level',
    'can_update_experience_level' => 'Can update experience level',
    'can_delete_experience_level' => 'Can delete experience level',
    //------------------------------------------------------------

    // Authentication
    'my_profile' => 'My Profile',
    'first_name' => 'Primer nombre',
    'last_name' => 'Apellido',
    'active' => 'Active',
    'inactive' => 'Inactive',
    'de_activate' => 'De-activate',
    'personal_info' => 'Personal info',
    'password_change' => 'Password change',
    'social_links' => 'Social links',
    'activity' => 'Activity',
    'invite_users' => 'Invite User',
    'enter_user_email' => 'Enter user email',
    'choose_a_role' => 'Choose a role',
    'role_name' => 'Role name',
    'enter_a_role_name' => 'Enter a role name',
    'manage_role' => 'Manage Role',
    'enter_first_name' => 'Enter first name',
    'enter_last_name' => 'Enter last name',
    'enter_your_email' => 'Enter your email',
    'enter_your_password' => 'Enter your password',
    'confirm_password' => 'Confirm password',
    'old_password' => 'Old password',
    'new_password' => 'New password',
    'login' => 'Login',
    'sign_up' => 'Sign up',
    'submit' => 'Submit',
    'hi_there' => 'Hi There!',
    'log_in_to_your_dashboard' => 'Log in to your dashboard.',
    'back_to_home' => 'Back to Home',
    'have_account' => 'Already have an account?',
    'forgot_password' => 'Forgot password?',
    'reset_password' => 'Reset password',
    'remember_password' => 'If you remember your password?',
    'copyright_text' => 'Copyright @',
    'type_first_name' => 'Type first name',
    'type_last_name' => 'Type last name',
    'type_name' => 'Type name',
    'type_email' => 'Type email',
    'gender' => 'Género',
    'contact_number' => 'Contact number',
    'contact' => 'Contact',
    'type_contact_number' => 'Type contact number',
    'type_age' => 'Type age',
    'address' => 'Address',
    'type_address' => 'Type address',
    'date_of_birth' => 'Fecha de nacimiento',
    'type_your_new_password' => 'Type your new password',
    'type_your_current_password' => 'Type your current password',
    'conform_password' => 'Confirm password',
    're_type_your_new_password' => 'Re-type your new password',
    'enter_email_to_reset_password' => 'Enter your email address to reset your password',
    'this_user_will_be_deleted_permanently' => 'This user will be deleted permanently.',
    'this_role_will_be_deleted_permanently' => 'This role will be deleted permanently.',

    // Btn
    'save' => 'Save',
    'cancel' => 'Cancel',
    'add_role' => 'Add Role',
    'edit_role' => 'Edit Role',
    'user_s' => 'User(s)',
    'manage_users' => 'Manage Users',
    'manage' => 'Manage',

    // Validation
    'validation_type' => 'Validation type',
    'range_validation' => 'Range Validation',
    'not_available' => 'Not available',

    // Datatable Fields
    'note' => 'Note',
    'datatables' => 'Datatables',
    'action' => 'Action',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'tab_filter' => 'Tab Filter',
    'phone' => 'Teléfono',
    'invoice' => 'Invoice',
    'status_2' => 'Status 2',
    'age' => 'Age',
    'time' => 'Time',
    'search_and_select' => 'Search and select',
    'sending_rate' => 'Sending rate',
    'age_range' => 'Age range',
    'max_age' => 'Max Age',
    'min_age' => 'Min Age',
    'list_with_segment' => 'List with segment',
    'list_with_gender' => 'List with Gender',
    'default_filter' => 'Default Filter',
    'basic' => 'Basic',
    'advance' => 'Advance',
    'want_to_filter_your_list' => 'Want to filter your list?',
    'datatable_responsive_note' => 'To get a responsive view of datatable in small screen just provide the <i class="text-primary">responsive: "true"</i> under the options variable',
    'datatable_filter_note' => 'There is an option to display filter in data-tables is <i class="text-primary">"datatableWrapper"</i>.  Default value of this key is <i class="text-primary">"true"</i> which gives the data-tables view with filter outside the table card (1st table). If we need to display any customized filter and search inside table card we need to change the <i class="text-primary">"datatableWrapper"</i> value to <i class="text-primary">"false"</i>',
    'datatable_paginate_note' => 'There is two options for displaying large data on a table. One is <i class="text-primary">"pagination"</i> and another one is <i class="text-primary">"load-more"</i>. You can use any one of this type under the table option <i class="text-primary">paginationType: " "</i>',
    'you_can_filter_your_data_table_which_are_created_based_on_segment' => 'You can filter your data table which are created based on segment',
    'you_can_filter_your_data_table_which_are_created_based_on_gender' => 'You can filter your data table which are created based on gender',

    // Form inputs
    'currency' => 'Currency',
    'message' => 'Message',
    'message_placeholder' => 'Write your message..',
    'upload_with_preview' => 'Upload with preview',
    'upload_your_file' => 'Upload your file',
    'upload' => 'Upload',
    'dropzone' => 'Dropzone',
    'radio' => 'Radio',
    'checkboxes' => 'Checkboxes',
    'male' => 'Masculino',
    'female' => 'Femenina',
    'other' => 'Otra',
    'text_editor' => 'Text Editor',
    'forms_and_fields' => 'Forms & Fields',
    'alphanumeric' => 'Alphanumeric',
    'readonly' => 'Readonly',
    'disabled' => 'Disabled',
    'state' => 'State',
    'required' => 'Required',
    'type_something' => 'Type something',
    'type_password' => 'Type password',
    're_type_password' => 'Re-Type password',
    'type_valid_email' => 'Type a valid e-mail',
    'datepicker' => 'Datepicker',
    'timepicker' => 'Timepicker',
    'recommended_default_file_validation' => 'File size must be below 1024KB',
    'recommended_custom_file_validation' => 'Image format should be jpg, jpeg, png',
    'recommended_dropzone_file_validation' => 'Every file must be below 1024KB',
    'file_size_limit_exceeded' => 'File size limit exceeded',

    // UI
    'enabled' => 'Enabled',
    'primary' => 'Primary',
    'secondary' => 'Secondary',
    'success' => 'Success',
    'danger' => 'Danger',
    'warning' => 'Warning',
    'info' => 'Info',
    'dark' => 'Dark',
    'link' => 'Link',
    'light' => 'Light',
    'loading' => 'loading',
    'click_to_copy' => 'Click to copy',
    'copy_icon_to_clipboard' => 'Copy icon to clipboard',
    'searchable' => 'Searchable',
    'initials' => 'Initials',
    'groups' => 'Groups',
    'notes' => 'Notes',
    'nothing_to_show' => 'Nothing to Show',
    'nothing_to_show_message' => 'Your response have no data',
    'radios' => 'Radios',
    'check_boxes' => 'Check Boxes',
    'job_area' => 'Job area',
    'tabs' => 'Tabs',

    // UI-Modals
    'modals' => 'Modals',
    'small' => 'Small',
    'medium' => 'Medium',
    'large' => 'Large',
    'extra_large' => 'Extra Large',
    'full_width' => 'Full Width',
    'full_height' => 'Full Height',
    'full_screen' => 'Full Screen',
    'confirm' => 'Confirm',
    'alert' => 'Alert',
    'congratulation' => 'Congratulation!',
    'continue' => 'Continue',

    // Setting
    'custom_field_setting' => 'Custom Field Setting',
    're-captcha-setting' => 'Google reCAPTCHA',
    'sms_setting' => 'SMS settings',

    // General setting
    'general' => 'General',
    'company_info' => 'Company info',
    'company_name' => 'Company name',
    'type_your_company_name' => 'Type your company name',
    'company_logo' => 'Company logo',
    'change_logo' => 'Change logo',
    'company_icon' => 'Company icon',
    'company_banner' => 'Company banner',
    'change_icon' => 'Change icon',
    'change_banner' => 'Change banner',
    'recommended_company_logo_size' => '(Recommended size: 210 x 50 px)',
    'recommended_company_icon_size' => '(Recommended size: 50 x 50 px)',
    'recommended_company_banner_size' => '(Recommended size: 1920 x 1080 px)',
    'language' => 'Language',
    'date_and_time_setting' => 'Date and time setting',
    'time_zone' => 'Time zone',
    'currency_setting' => 'Currency setting',
    'currency_symbol' => 'Currency symbol',
    'layout' => 'Layout',
    'ltr' => 'LTR',
    'rtl' => 'RTL',

    // Email setting
    'email_sent_from_name' => 'Email sent from name',
    'type_email_sent_from_name' => 'Type email sent from name',
    'email_sent_from_email' => 'Email sent from email',
    'type_email_sent_from_email' => 'Type email sent from email',
    'email_use_for' => 'Email use for',
    'type_email_use_for' => 'Type email use for',
    'supported_mail_services' => 'Supported mail services',
    'hostname' => 'Host name',
    'type_host_name' => 'Type host name',
    'access_key_id' => 'Access key id',
    'type_access_key_id' => 'Type access key id',
    'secret_access_key' => 'Secret access key',
    'type_secret_access_key' => 'Type secret access key',
    'domain_name' => 'Domain name',
    'type_domain_name' => 'Type domain name',
    'api_key' => 'Api key',
    'type_api_key' => 'Type api key',
    'smtp_host' => 'SMTP host',
    'type_smtp_host' => 'Type SMTP host',
    'port' => 'Port',
    'type_port_number' => 'Type port number',
    'password_to_access' => 'Password to access',
    'type_password_to_access' => 'Type password to access',
    'encryption_type' => 'Encryption type',
    'type_encryption_type' => 'Type encryption type',

    // SMS setting
    'sms_send_from_name_or_phone_number' => 'SMS send from name / phone number',
    'type_a_name_or_number_you_want_to_sent_sms_from' => 'Type a name or number you want to sent SMS from',
    'sms_driver' => 'SMS driver',
    'key' => 'Key',
    'secret_key' => 'Secret key',
    'type_nexmo_key' => 'Type nexmo key',
    'type_nexmo_secret_key' => 'Type nexmo secret key',
    'test_number' => 'Test number',

    // Dashboard
    'dashboard' => 'Dashboard',
    'default' => 'Default',

    // Template
    'subject' => 'Subject',
    'title' => 'Title',
    'content' => 'Content',
    'restore_to_default' => 'Restore To Default',

    // Months
    'january' => 'January',
    'february' => 'February',
    'march' => 'March',
    'april' => 'April',
    'may' => 'May',
    'jun' => 'Jun',
    'july' => 'July',
    'august' => 'August',
    'september' => 'September',
    'october' => 'October',
    'november' => 'November',
    'december' => 'December',

    // User and Roles
    'no_of_users' => 'No. Of users',
    'user_and_roles' => 'Users & Roles',
    'custom_fields' => 'Custom fields',
    'templates' => 'Templates',
    'notification_events' => 'Notification events',
    'status_invited' => 'Invited',
    'invited' => 'Invited',
    'remove' => 'Remove',
    'manage_permission' => 'Manage Permission',
    'you_are_invited' => 'You are invited',

    // Title
    'functional' => 'Functional',
    'responsive' => 'Responsive',
    'filter_type' => 'Filter Type',
    'paginated' => 'Paginated',
    'profile_view' => 'Profile View',
    'list_view' => 'List View',
    'pagination' => 'Pagination',

    // Sidebar
    'authentication' => 'Authentication',
    'registration' => 'Registration',
    'forget_password' => 'Forget Password',
    'profile_list' => 'Profile List',
    'user_profile' => 'User Profile',
    'card_view' => 'Card View',
    'app_settings' => 'App Settings',
    'basic_settings' => 'Basic Settings',
    'others' => 'Others',
    'copy' => 'Copy',
    'blank' => 'Blank',
    'data' => 'Data',
    'blank_page' => 'Blank page',

    // re-captcha
    're_captcha' => 'reCAPTCHA',
    'google_re_captcha' => 'Google reCAPTCHA',
    'site_key' => 'Site key',
    'type_site_key' => 'Type site key',
    'type_secret_key' => 'Type secret key',
    'enable_recaptcha' => 'Enable reCAPTCHA',

    // Notification
    'event_name' => 'Event name',
    'event_channel' => 'Event Channel',
    'notification_audiences' => 'Notification audiences',
    'notification_channel' => 'Notification channel',
    'this_audiences_field_is_required' => 'This audiences field is required',
    'permission_field_is_required' => 'Permission field is required',
    'contents' => 'Contents',
    'mail_subject' => 'Mail subject',
    'this_field_will_be_used_as_the_email_subject_and_identify_the_template' => 'This field will be used as the email subject and identify the template',
    'notification_password' => 'password updated',
    'notification_email' => 'email updated',
    'notification_duplicated' => 'duplicated',
    'notification_confirmed' => 'confirmed',
    'notification_sent' => 'sent',
    'notification_bulk' => 'bulk imported',
    'notification_blacklisted' => 'blacklisted',
    'notification_' => '',
    'notification_invitation' => 'invitation',
    'notification_joined' => 'joined',
    'password_reset' => 'Password reset',
    'row' => 'Datatable row',
    'delivery' => 'mail',
    'password_hint_note' => 'The password should contain one upper case, one lower case, one special character ( +=#?!@$%^&*- ), and numbers. It should be a minimum of 8 characters.',

    // Backend response
    'update_failed_response' => ':name',
    'status_error' => 'This user status can not be updated',
    'can_not_delete_these_one' => 'You can not delete these',
    'password_warning' => 'Password must be 8 character with A-Z, a-z, 0-9 and at least one special character like ( +=#?!@$%^&*- )',

    // Notification top bar
    'new' => 'nuevo',
    'old' => 'Old',
    'notification_from' => 'Notification from',
    'all_notification' => 'All Notification',
    'demo_crud' => 'Demo crud',
    'basic_list_view_table' => 'Basic list view table',
    'type_test_number' => 'Type test number',

    // mail driver
    'mandrill' => 'Mandrill',
    'amazon_ses' => 'Amazon SES',
    'smtp' => 'SMTP',
    'mailgun' => 'Mailgun',
    'sparkpost' => 'SparkPost',
    'sendmail' => 'Sendmail',
    'tls' => 'TLS',
    'ssh' => 'SSH',
    'mandrill_key' => 'Mandrill key',
    'sparkpost_key' => 'SparkPost key',
    'choose_one' => 'Choose one',
    'user_name' => 'User name',
    'nothing_store' => 'Nothing has been added.',
    'region' => 'Region',

    // Template
    'reset_password_text' => 'Hi,<br>
                        You have requested to change your password.<br>
                        Please click the link below to change your password!<br>
                        {reset_password_url}',

    'user_invitation_text' => 'Hi,<br>
                You are invited to join with the team on {company_name}.<br>
                Please click the link below to accept the invitation!<br>
                {invitation_url}',

    // User dashboard permission languages

    // Authentication
    'view_registration' => 'Can see registration',
    'view_forget_password' => 'Can see forget password',
    'view_reset_password' => 'Can see reset password',

    // User and roles
    'user_role' => 'User and Role',
    'view_user_roles' => 'Can see user and roles',
    'attach_users_to_roles' => 'Can attach user to role',
    'edit_user' => 'Edit User',
    //settings
    'manage_settings' => 'Can manage settings',

    // settings
    'view_sms_settings' => 'Can view SMS settings',
    'update_sms_settings' => 'Can update SMS settings',
    'view_recaptcha_settings' => 'Can view Google Recaptcha settings',
    'update_recaptcha_settings' => 'Can update Google Recaptcha settings',
    'email_setup' => 'Email Setup',
    'sms_setup' => 'SMS Setup',

    //backend response message
    'submitted_response' => ':name has been submitted successfully',
    'file' => 'File',
    'file_upload_response' => ':name has been uploaded successfully',
    'update' => 'Update',

    //errors
    '400_bad_request' => '400 - Bad request',
    '401_unauthorized' => '401 - Unauthorized',
    '403_Forbidden' => '403 - Forbidden',
    '404_page_not_found' => '404 - Page not found',
    '500_internal_server_error' => '500 - Internal server error',
    '503_service_unavailable' => '503 - Service unavailable',

    //auth
    'user_registration' => 'User Registration',
    'reset_pass' => 'Reset Password',

    //sample page
    'event' => 'Event',
    'report' => 'Report',
    'count' => 'Count',
    'average' => 'Average',
    'order_report_by' => 'Order report by :',
    'task' => 'Task',
    'tasks' => 'Tasks',
    'enter_title' => 'Enter Title',
    'enter_description' => 'Enter Description',
    'incorrect_delivery_credential' => 'Configure email setup properly',
    'applicant' => 'Applicant',
    'edit_job_post' => 'Edit job post',
    'sharable_link' => 'Sharable link',
    'activate' => 'Activate',
    'deactivate' => 'Deactivate',
    'job_stage' => 'Job stage',
    'thumbnail_image' => 'Thumbnail image',
    'job_stage_reordered' => 'Job stage re-ordered',
    'applicant_stage' => 'Applicant stage',
    'job_post' => 'Job post',
    'job_posts' => 'Job Posts',
    'job_applicant' => 'Job applicant',
    'job_closed' => 'Job Closed',
    'job_activated' => 'Job Activated',
    'apply_form_updated' => 'Apply Form Updated',
    'job_post_template_updated' => 'Job Post Template Updated',
    'review' => 'Review',
    'notification_disqualified' => 'disqualified',
    'you_have' => 'You have',
    'completed_item' => 'Completed item',
    'pending_item' => 'Pending item',

    // Dashboard - Job Module
    'job_title' => 'Job title',
    'type_title' => 'Type title',
    'choose_job_type' => 'Choose job type',
    'choose_department' => 'Choose department',
    'choose_location' => 'Choose location',
    'write_description' => 'Type description',
    'salary' => 'Salary',
    'type_salary' => 'Type salary',
    'last_submission' => 'Last submission',
    'last_submission_date' => 'Last submission date',
    'todo' => 'Todo',
    'job_post_template' => 'Job post template',
    'assign_team_member' => 'Assign team member',
    'failed_to_assign_this_members_to_this_job.' => 'Failed to assign this members to this job.',
    'member_already_assigned_to_this_job' => 'Sorry, member already assigned to this job.',
    'this_member_could_not_be_deleted_from_hiring_team' => 'Sorry, this member could not be deleted from hiring team.',
    'member' => 'Member',
    'reason' => 'Reason',
    'rejection' => 'Rejection',
    'compose' => 'Compose',
    'type_and_enter' => 'Type and Enter',
    'do_not_notify' => 'Do not notify',
    'notify' => 'Notify',
    'start_date' => 'Start date',
    'end_date' => 'End date',
    'type_note_here' => 'Type note here',
    'disqualification_reason' => 'Disqualification reason',
    'default_disqualification_reason_note' => 'No disqualification reason given.',
    'email_sent_successfully' => 'Email has been sent successfully.',
    'send' => 'Send',
    'write_a_message_here' => 'Write a message here',
    'mail_to' => 'Mail to',
    'event_type' => 'Event type',
    'show' => 'Show',
    'hide' => 'Hide',
    'complete' => 'Complete',
    'disqualification_mail_for_candidate' => 'Disqualification mail for candidate',
    'not_given' => 'not given',
    'invalid_job_post' => 'Invalid Job Post',
    'create_event_mail_for_candidate' => 'Create event mail for candidate',
    'failed_to_create_note' => 'Failed to create note',
    'job_apply_response_for_candidate' => 'Job apply response for candidate',

    'timeline_for_applied_job' => '<strong>{candidate_name}</strong> has applied for the Job <strong>{job_post_name}</strong> through online',
    'timeline_for_applied_job_by_system' => '<strong>{user_name}</strong> has been added  <strong>{candidate_name}</strong> for the Job Post: <strong>{job_post_name}</strong> ',
    'timeline_for_change_stage' => '<strong>{user_name}</strong> moved <strong>{candidate_name}</strong> to <strong>{stage_name}</strong>',
    'timeline_for_candidate_disqualified' => '<strong>{candidate_name}</strong> is disqualified from job <strong>{job_post_name}</strong> by <strong>{user_name}</strong>.<br/><strong>Disqualification reason:</strong> {disqualification_reason}',
    'timeline_for_job_hired' => 'Congratulation, <strong>{candidate_name}</strong> is hired by <strong>{user_name}</strong> on job <strong>{job_post_name}</strong>',
    'timeline_for_give_review' => '<strong>{candidate_name}</strong> has given <strong>{review} star</strong> review by <strong>{user_name}</strong>',
    'timeline_for_create_event' => '<strong>{candidate_name}</strong> has <strong>{event_type}</strong> with <strong>{attendees}</strong> on date <strong>{date}</strong>',
    'timeline_for_create_note' => '<strong>{user_name}</strong> has added note on <strong>{candidate_name}</strong>',

    'notification_applied' => 'Applied',
    'others_information' => 'Others information',
    'you_have_to_verify_your_email_first' => 'You have to verify your email first!',
    'submitted' => 'Submitted',
    'in_progress' => 'In progress...',

    //Notification template tags
    'the_resource_name_of_the_event' => 'The resource name of the event',
    'the_profile_who_performed_the_action' => 'The Profile who performed the action',
    'name_of_the_application' => 'Name of the application',
    'logo_of_the_application' => 'Logo of the application',
    'the_profile_who_will_receive_the_notification' => 'The Profile who will receive the Notification',
    'page_link_of_resource' => 'Page link of resource',
    'invitation_url_for_the_profile' => 'Invitation url for the Profile',
    'reset_password_url_of_profile' => 'Reset password url of Profile',
    'medium_in_which_event_will_be_held' => 'Medium in which event will be held',
    'event_is_about' => 'Event is about',
    'location_of_event' => 'Location of event',
    'starting_time' => 'Starting time',
    'ending_time' => 'Ending time',
    'the_person_who_created_note' => 'The person who created note',
    'the_person_who_applied' => 'The person who applied',
    'scheduled_time_of_the_event' => 'Scheduled time of the event',
    'scheduled_location_of_the_event' => 'Scheduled location of the event',

    //Front End Random lang
    'you_can_filter_your_candidates_based_on_reviews' => 'You can filter your candidates based on reviews',
    'not_yet' => 'Not yet',
    'review_one' => 'One',
    'review_two' => 'Two',
    'review_three' => 'Three',
    'review_four' => 'Four',
    'review_five' => 'Five',
    'want_to_filter_through_gender' => 'Want to filter through gender?',
    'you_can_filter_your_candidates_based_on_gender' => 'You can filter your candidates based on gender.',
    'this_field_require_only_one_attachment' => 'This field require only one attachment',
    'this_field_format_should_be_pdf_doc_docx' => 'This field format should be pdf, doc, docx',
    'active_jobs' => 'trabajo activo',
    'sharable_link_anyone_with_this_link_can_apply_to_this_job' => 'Use this link to share this job with someone outside of application.
                    Anyone with this link can apply to this job.',
    'shareable_link_was_copied_successfully' => 'Shareable link was copied successfully',
    'sorry_you_can_not_copy_the_link' => 'Sorry you can not copy the link',
    'notifications' => 'Notifications',
    'logout' => 'Logout',
    'select_what_should_be_included_or_required_in_the_apply_form' => 'Select what should be included or required in the apply form.',
    'view_only_you_can_not_modify_basic_information_setting' => 'View only: You can not modify basic information setting.',
    'sharable_thumbnail_instruction' => 'This image will be used as thumbnail when you share job post link. Maximum size: 512KB',
    'disqualified' => 'Descalificado',
    'no_job_post_found' => 'No job post found.',
    'job_post_closed' => 'This job post has been closed!',
    'email_address' => 'Email address',
    'send_test_email' => 'Send test email',
    'test_email' => 'Test email',
    'email_setup_is_not_correct' => 'Email setup is not correct.',
    'attendees_are_the_persons_among_the_hiring_team_of_this_job_post' => 'Attendees are the persons among the hiring team of this job post who will be attending this event.',
    'cron_job' => 'Cron Job',
    'command' => 'Command',
    'command_without_php_path' => 'Command without php path',
    'see_documentation' => 'See Documentation',
    'cron_job_description_message' => 'For executing scheduled jobs',
    'cron_job_setting_suggestion' => 'We are providing the cron job command and highly recommend to run it every minute(once per minute ****). Copy the command and insert it to your hosted server\'s crontab. For more help you can see the documentation.',
    'cron_job_setting_warning' => 'If you will not be able to change any images on the application (Profile picture, icon etc.) in your application, then you may think symlink() is disabled. Symlink permission has been disabled from your Hosted server. Please contact your hosting provider to enable it.',
    'cron_job_setting_suggestion_1' => 'Note: Once a storage folder (with clip icon) has been created on your hosted server, you need to delete the command from your hosted server.',
    'section_name_should_be_unique' => 'Section name should be unique',
    'no_delivery_settings_found' => 'No email settings found.',
    'no_delivery_settings_warning' => 'For sending invitation you must set up email settings. Click {location} to add email settings.',
    'no_delivery_settings_warning_none' => 'For sending invitation you must set up email settings and setup cron job on your hosting server.',
    'no_delivery_settings_warning_on_import' => 'To import employees you must set up email settings. Click {location} to add email settings.',
    'no_delivery_settings_warning_none_on_import' => 'To import employees you must set up email settings and setup cron job on your hosting server.',
    'cron_job_settings_warning' => 'Please make sure you setup the cron job on your hosted server as instructed on the {documentation} for sending emails.',
    'okay' => 'Okay',
    'wait_a_minute' => 'Wait a minute!',
    'popup_subtitle_for_redirect_notification_template' => 'We have some email & notification templates for you. Please have a look on these for customization.',
    'vacancy' => 'Vacancy',
    'cancel_invitation' => 'Cancel invitation',
    'you_are_going_to_cancel_an_invitation' => 'You are going to cancel an invitation',
    'video_meeting' => 'Video meeting',
    'topic' => 'Topic',
    'duration' => 'Duration',
    'zoom_meeting' => 'Zoom meeting',
    'integrations' => 'Integrations',
    'zoom_settings' => 'Zoom settings',
    'api_secret' => 'Api secret',
    'invalid_zoom_set_up' => 'Invalid zoom setup!',
    'zoom_meeting_link_copied_successfully' => 'Zoom meeting link copied successfully',
    'zoom_meeting_start_url' => 'Zoom meeting start link',
    'zoom_meeting_join_url' => 'Zoom join Url',
    'zoom_meeting_topic' => 'Zoom meeting topic',
    'zoom_meeting_duration' => 'Zoom meeting duration',
    'not_scheduled' => 'Not scheduled',
    'upload_resume' => 'Upload resume',
    'no_of_vacancy' => 'Number of Vacancy',
    'invalid_imap_configuration' => 'Invalid imap configuration',
    'emails_has_been_synced_with_system' => 'Emails has been synced with system',
    'imap_settings' => 'Imap settings',
    'imap_port' => 'Imap port',
    'imap_encryption' => 'Imap encryption',
    'imap_server' => 'Imap server',
    'ssl' => 'SSL',
    'from' => 'From',
    'discard' => 'Discard',
    'to_get_candidate_conversation_please_set_up_imap_settings' => 'To get candidate conversation please set up {imap_setting}',
    'imap_setting' => 'Imap setting',
    'by' => 'by',
    'why_you_think_you_are_good_for_this_job_' => 'Por qué crees que eres bueno para este trabajo?',
    'write_something_about_you_' => 'escribe algo sobre ti..',
    'upload_your_resume_here_' => 'Upload your resume here',
    'remove_file' => 'Remover archivo',
    'upload_your_attachment' => 'Sube tu archivo adjunto',
    'work_experience' => 'Experiencia laboral',
    'upload_your_resume_here' => 'Sube tu currículum aquí',
    'hired' => 'Contratado',
    'imap_documentation_notes' => '1. This imap settings will effect on candidate conversation via email. This will be used to receive mail from candidate and preview conversation between system email notification while creating an event , hiring team email from conversation from system and candidate email.' .
        '<br>'.
        '2. You must setup the Cron job in your hosted server for getting email conversation. Please checkout the documentation.'.
        '<br>'.
        '3. Sending email (SMTP) and Receiving emails (IMAP) from candidates as conversations you must use the same email for both SMTP and IMAP.',
    'hero' => 'Hero',
    'upload_image' => 'Upload image',
    'hero_image' => 'Hero image',
    'job_post_cover_image' => 'Job post cover image',
    'inactive_jobs'=> 'trabajo inactivo',
    'draft_jobs'=> 'borrador de trabajo',
    'set_job_alert'=> 'Establecer alerta de empleo',
    'view_site' => 'Ver sitio',
    'work_arrangement' => 'Acuerdo de trabajo',
    'experience_level' => 'Nivel de experiencia',
    'get_job_alert' => 'Obtener alerta de empleo',
    'search_your_dream_job' => 'Busca el trabajo de tus sueños',
    'job_alert_note' => 'Manténgase informado con nuestra función de alerta de empleo: habilite las notificaciones de empleo para recibir actualizaciones oportunas sobre nuevas ofertas de trabajo adaptadas a sus preferencias, lo que garantiza que nunca se perderá emocionantes oportunidades profesionales.',
    'read_more_about_us' => 'Leer más sobre nosotros',
    'all_jobs' => 'Todos los trabajos',
    'number_of_vacancies' => 'Numero de vacantes',
    'working_arrangement' => 'Disposición de trabajo',
    'about_us' => 'Sobre nosotros',
], include 'custom.php');
