<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class SecurityPosture extends \Google\Model
{
  /**
   * @var string
   */
  public $changedPolicy;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $postureDeployment;
  /**
   * @var string
   */
  public $postureDeploymentResource;
  /**
   * @var string
   */
  public $revisionId;

  /**
   * @param string
   */
  public function setChangedPolicy($changedPolicy)
  {
    $this->changedPolicy = $changedPolicy;
  }
  /**
   * @return string
   */
  public function getChangedPolicy()
  {
    return $this->changedPolicy;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setPostureDeployment($postureDeployment)
  {
    $this->postureDeployment = $postureDeployment;
  }
  /**
   * @return string
   */
  public function getPostureDeployment()
  {
    return $this->postureDeployment;
  }
  /**
   * @param string
   */
  public function setPostureDeploymentResource($postureDeploymentResource)
  {
    $this->postureDeploymentResource = $postureDeploymentResource;
  }
  /**
   * @return string
   */
  public function getPostureDeploymentResource()
  {
    return $this->postureDeploymentResource;
  }
  /**
   * @param string
   */
  public function setRevisionId($revisionId)
  {
    $this->revisionId = $revisionId;
  }
  /**
   * @return string
   */
  public function getRevisionId()
  {
    return $this->revisionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SecurityPosture::class, 'Google_Service_SecurityCommandCenter_SecurityPosture');
